<?php

namespace App\Http\Controllers;

use App\Episode;
use App\Livetv;
use App\Movie;
use App\Serie;
use App\Anime;
use Illuminate\Support\Str;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{

    const FEATURED = "featured";
    const CREATED_AT = "created_at";
    const VIEWS = "views";




    public function store(Request $request)
    {
        if ($request->hasFile('image')) {
            $filename = Storage::disk('movies')->put('', $request->image);
            $data = ['status' => 200, 'image_path' => $request->root() . '/api/movies/image/' . $filename, 'message' => 'successfully uploaded'];
        } else {
            $data = ['status' => 400, 'message' => 'could not be uploaded'];
        }

        return response()->json($data, $data['status']);

    }




    public function __construct()
    {
        $this->middleware('auth');
    }

    // navigation routes for the admin panel

    public function updateWebPanel(Request $request)
    {

       
        $user = Auth::user();

        $this->validate($request, [
            'webpanelversion' => 'required'
        ]);


        DB::table('settings')
            ->update(
                array( "webpanelversion" => $request->webpanelversion)

            );
            
        return response()->json("Success", 204);

    }



    public function set(Request $request)
    {

       
        $user = Auth::user();

        $this->validate($request, [
            'startapp_banner' => 'required'
        ]);


        $s = DB::table('settings')
            ->update(
                array("startapp_banner" => $request->startapp_banner)

            );
            
            if ($s != null) {
        
                $data = ['status' => 200, 'message' => 'successfully removed',];
            } else {
                $data = ['status' => 400, 'message' => 'could not be deleted',];
            }
    
             return response()->json($data, 200);

    }



    public function certification()
    {
        return view('admin.certification');
    }

    public function home()
    {
        return view('admin.home');
    }

    public function index()
    {


        if (Auth()->user() && Auth()->user()->role == 'admin') {
            return view('admin.index');
        
        } else if (Auth()->check()) {
            Auth()->logout();
        }

        return redirect('/')->with('message', 'You do not have the permissions to access this route');

    }



    public function comments()
    {
        return view('admin.comments');
    }

    public function users()
    {
        return view('admin.users');
    }

    public function movies()
    {
        return view('admin.movies');
    }

    public function series()
    {
        return view('admin.series');
    }


    public function animes()
    {
        return view('admin.animes');
    }


    public function mangas()
    {
        return view('admin.mangas');
    }



    public function streaming()
    {
        return view('admin.streaming');
    }

    public function servers()
    {
        return view('admin.servers');
    }



    public function headers()
    {
        return view('admin.headers');
    }

    public function genres()
    {
        return view('admin.genres');
    }



    
    public function collections()
    {
        return view('admin.collections');
    }


    public function networks()
    {
        return view('admin.networks');
    }

    public function casters()
    {
        return view('admin.casters');
    }



    public function notifications()
    {
        return view('admin.notifications');
    }

    public function settings()
    {
        return view('admin.settings');
    }

    public function account()
    {
        return view('admin.account');
    }


    public function reports()
    {
        return view('admin.reports');
    }



    public function suggestions()
    {
        return view('admin.suggestions');
    }


    public function ads()
    {
        return view('admin.ads');
    }


    public function upcomings()
    {
        return view('admin.upcomings');
    }

    public function plans()
    {
        return view('admin.plans');
    }



    public function categories()
    {
        return view('admin.categories');
    }

    public function previews()
    {
        return view('admin.previews');
    }


    public function languages()
    {
        return view('admin.languages');
    }

    public function featured()

    {


        return view('admin.featured');

    }

    public function certifications()

    {


        return view('admin.certifications');

    }





    public function topcontent()

    {


        $selectMovie = [
            'id', 'title', 'poster_path', 'backdrop_path',
                    'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'release_date', 'pinned',
                    'created_at','updated_at', 'views', DB::raw("'movie' AS type"),DB::raw("0 AS newEpisodes")
        ];


        $selectSerie = [
            'id', 'name', 'poster_path', 'backdrop_path',
                        'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date',
                        'pinned', 'created_at','updated_at', 'views', DB::raw("'serie' AS type"),"newEpisodes"
        ];


        $selectAnime = [
            'id', 'name', 'poster_path', 'backdrop_path',
                    'backdrop_path_tv', 'vote_average', 'subtitle', 'overview', 'first_air_date AS release_date', 
                    'pinned', 'created_at','updated_at','views', DB::raw("'anime' AS type"),"newEpisodes"
        ];

        $genresMovies =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN movie_genres ON genres.id = movie_genres.genre_id WHERE movie_genres.movie_id = movies.id)
        AS genre_name');


        $genresSeries =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN serie_genres ON genres.id = serie_genres.genre_id WHERE serie_genres.serie_id = series.id) AS genre_name');

        $genresAnimes =
        DB::raw('(SELECT SUBSTRING_INDEX(GROUP_CONCAT(genres.name SEPARATOR ", "), ",", 1)
        FROM genres JOIN anime_genres ON genres.id = anime_genres.genre_id WHERE anime_genres.anime_id = animes.id) AS genre_name');



        $movies = DB::table(function ($query) use ($selectMovie,$genresMovies) {
            $query->select(array_merge(
                $selectMovie,
                [
                    $genresMovies,
                ]
            ))
                ->from('movies')
                ->where('active', '=', 1)
                ->limit(5);
        })
            ->orderByDesc('views')
            ->get();



            $series = DB::table(function ($query) use ($selectSerie,$genresSeries) {
                $query->select(array_merge(
                    $selectSerie,
                    [
                        $genresSeries,
                    ]
                ))
                    ->from('series')
                    ->where('active', '=', 1)
                    ->limit(5);
            })->orderByDesc('views')->get();



            $animes = DB::table(function ($query) use ($selectAnime,$genresAnimes) {
                $query->select(array_merge(
                    $selectAnime,
                    [
                        $genresAnimes,
                    ]
                ))
                    ->from('animes')
                    ->where('active', '=', 1)
                    ->limit(5);
            })->orderByDesc('views')->get();
    

       //ray()->showQueries1();
        // ray()->measure();


        return response()
        ->json([
            'movies' => $movies,
            'series' => $series,
            'animes' => $animes]);

    }



    public function topcontentmovies()

    {

        $movies = Movie::withOnly(['genres.genre','substitles','networks.network'])
        ->select('movies.id','movies.title','movies.poster_path','movies.views')->where('active', '=', 1)
        ->orderByDesc('views')->limit(5)->get();


        return response()
            ->json($movies->makeHidden(['videos','casterslist','casters','genres','genreslist','substitles'])
            ->toArray(), 200);

    }





    public function topcontentseries()

    {

        $movies = Serie::withOnly([
            'genres.genre','networks.network'])->select('series.id','series.name','series.poster_path','series.views')->where('active', '=', 1)
        ->orderByDesc('views')->limit(5)->get();

        return response()
            ->json($movies->makeHidden(['seasons','casterslist','casters','genres','genreslist','substitles'])->toArray(), 200);

    }


    public function topcontentanimes()

    {

        $movies = Anime::withOnly([
            'genres.genre','networks.network'])->select('animes.id','animes.name','animes.poster_path','animes.views')->where('active', '=', 1)
        ->orderByDesc('views')->take(5)->get();

        return response()
            ->json($movies->makeHidden(['seasons','casterslist','casters','genres','genreslist','substitles'])->toArray(), 200);

    }



    // most viewed metrics

    public function topMovies()
    {
        $movies = Movie::orderBy(self::VIEWS, 'desc')->limit(5)->get();

        return response()->json($movies, 200);
    }

    public function topSeries()
    {
        $series = anime::all()->makeHidden(['seasons', 'genres'])->sortByDesc(self::VIEWS);

        if ($series->count() > 10) {
            $series = $series->take(10);
        }

        return response()->json($animes, 200);
    }

    public function topEpisodes()
    {
        $episodes = Episode::orderBy(self::VIEWS, 'desc')->limit(10)->get();

        return response()->json($episodes, 200);
    }

    public function topLivetv()
    {
        $livetv = Livetv::orderBy(self::VIEWS, 'desc')->limit(10)->get();

        return response()->json($livetv, 200);
    }

    public function topUsers()
    {
        $users = User::orderBy('id', 'desc')->limit(10)->get();

        return response()->json($users, 200);
    }



    public function moviesCountViews()
    {
        $contentTypes = ['movies', 'series', 'animes', 'livetvs'];
        $counts = [];
    
        try {
            foreach ($contentTypes as $type) {
                $tableName = $type === 'livetvs' ? 'livetvs' : Str::plural($type);
                $counts[$type] = DB::table($tableName)->sum('views') ?? 0;
            }
    
            return response()->json([
                'status' => 'success',
                'data' => [
                    'count' => $counts
                ]
            ], 200);
        } catch (\Exception $e) {
            \Log::error('Error in moviesCountViews: ' . $e->getMessage());
            return response()->json([
                'status' => 'error',
                'message' => 'An error occurred while fetching view counts.'
            ], 500);
        }
    }


    public function moviesInactiveCount()
    {
        return response()->json([
            'status' => 'success',
            'data' => [

                'count' => [
                    'movies' => DB::table('movies')->where('active', '=', 0)->count(),
                    'series' => DB::table('series')->where('active', '=', 0)->count(),
                    'animes' => DB::table('animes')->where('active', '=', 0)->where('active', '=', 0)->count(),
                    'tvs' => DB::table('livetvs')->where('active', '=', 0)->count()
                ],

            ]
        ]);
    }

    public function moviesCount()
    {
        return response()->json([
            'status' => 'success',
            'data' => [

                'count' => [
                    'reports' => DB::table('reports')->count(),
                    'movies' => DB::table('movies')->count(),
                    'series' => DB::table('series')->count(),
                    'animes' => DB::table('animes')->count(),
                    'tvs' => DB::table('livetvs')->count(),
                    'users' => DB::table('users')->count()
                ],

            ]
        ]);
    }

    public function updateMailSettings(Request $request){
        // some code
        $env_update = $this->changeEnv([
            'MAIL_DRIVER'   => 'sendmail',
            'MAIL_HOST'   => $request->get('email_smtp_adress'),
            'MAIL_PORT'       => $request->get('email_smtp_port')
        ]);
        if($env_update){
            // Do something
        } else {
            // Do something else
        }
        // more code
    }

    protected function changeEnv($data = array()){
        if(count($data) > 0){

            // Read .env-file
            $env = file_get_contents(base_path() . '/.env');

            // Split string on every " " and write into array
            $env = preg_split('/\s+/', $env);;

            // Loop through given data
            foreach((array)$data as $key => $value){

                // Loop through .env-data
                foreach($env as $env_key => $env_value){

                    // Turn the value into an array and stop after the first split
                    // So it's not possible to split e.g. the App-Key by accident
                    $entry = explode("=", $env_value, 2);

                    // Check, if new key fits the actual .env-key
                    if($entry[0] == $key){
                        // If yes, overwrite it with the new one
                        $env[$env_key] = $key . "=" . $value;
                    } else {
                        // If not, keep the old one
                        $env[$env_key] = $env_value;
                    }
                }
            }

            // Turn the array back to an String
            $env = implode("\n", $env);

            // And overwrite the .env with the new data
            file_put_contents(base_path() . '/.env', $env);

            return true;
        } else {
            return false;
        }
    }


}
